#include <iostream>
#include <opencv2/opencv.hpp>
#include <vector>
#include "memx/MxAccl.h"
#include <string>
#include <numeric>
#include <fstream>

namespace fs = std::filesystem;

// Imagenet folder
const fs::path imagenetPath = "imagenet100/";
std::string baseFilename = "ILSVRC2012_val_";

// model file 
const fs::path modelPath = "resnet.dfp";

//model info
MX::Types::MxModelInfo model_info;

std::vector<int> ground_truth  = {  65,970,230,809,516,57,334,415,674,332,109,286,370,757,595,147,473,23,478,517,334,173,
                                    948,727,23,846,270,167,55,858,324,573,150,981,586,887,32,398,777,74,516,756,129,198,
                                    256,725,565,167,717,394,92,29,844,591,358,468,259,994,872,588,474,183,107,46,842,390,
                                    101,887,870,841,467,149,21,476,80,424,159,275,175,461,970,160,788,58,479,498,369,28,487,
                                    50,270,383,366,780,373,705,330,142,949,349 };

int totalSamples = 0;
int counter = 100;
int correctTop1 = 0;
int correctTop5 = 0;

cv::Mat preprocessImage(cv::Mat& img) {
    
    cv::resize(img, img, cv::Size(224, 224));

    if (img.channels() == 1) {
        cv::cvtColor(img, img, cv::COLOR_GRAY2BGR);
    }

    cv::Mat img_float;
    img.convertTo(img_float, CV_32F);

    return img_float; 
}

void printScore(const std::vector<float*>& ofmaps){

    totalSamples+=1;
    std::vector<int> indices(1000);

    std::iota(indices.begin(), indices.end(), 0);

    std::sort(indices.begin(), indices.end(),
        [&ofmaps](int i1, int i2) {
            return ofmaps[0][i1] > ofmaps[0][i2];
        }
    );

    int trueIndex = ground_truth[totalSamples-1];

    if (indices[0] == trueIndex) {
            correctTop1++;
    }
    // Check top-5 accuracy
    if (std::find(indices.begin(), indices.begin() + 5, trueIndex) != indices.begin() + 5) {
        correctTop5++;
    }
}

int main(){

    MX::Runtime::MxAccl accl(modelPath.c_str());

    model_info = accl.get_model_info(0);

    std::cout << "Connected stream \n\n\n";
    accl.start(true);

    std::vector<float*> input_data;
    input_data.reserve(model_info.num_in_featuremaps);

    std::vector<float*> ofmap;

    ofmap.reserve(model_info.num_out_featuremaps);
    
    for(int j=0; j<model_info.num_out_featuremaps ; ++j){
        float * fmap = new float[model_info.out_featuremap_sizes[j]];
        ofmap.push_back(fmap);
    }

    for(int i =1; i <= counter; i++){
        
        cv::Mat inframe;
        int recvinf_label;

        std::stringstream ss;
        ss << baseFilename << std::setw(8) << std::setfill('0') << i << ".JPEG";
        fs::path fullPath = imagenetPath / ss.str();
        inframe = cv::imread(fullPath.string());

        if(!inframe.empty()){

            cv::Mat preProcframe = preprocessImage(inframe);

            input_data.push_back((float*)preProcframe.data);
            
            accl.send_input(input_data, model_info.model_index, 0, false);

            accl.receive_output(ofmap, model_info.model_index, recvinf_label, true);

            printScore(ofmap);
            input_data.clear();
            
        }

    }

    for (auto& fmap : ofmap) {
        delete[] fmap;
        fmap = NULL;
    }  
    
    // Print accuracy
    std::cout << "Top-1 Accuracy: " << static_cast<double>(correctTop1) / totalSamples * 100.0 << "%" << std::endl;
    std::cout << "Top-5 Accuracy: " << static_cast<double>(correctTop5) / totalSamples * 100.0 << "%" << std::endl;

    return 1;
}
